export default [
  {
    id: 1,
    name: 'Round Robin Policy',
    description: 'Distributes conversations evenly among agents',
    assignment_order: 'round_robin',
    conversation_priority: 'earliest_created',
    fair_distribution_limit: 100,
    fair_distribution_window: 3600,
    enabled: true,
    assigned_inbox_count: 3,
    created_at: 1704110400,
    updated_at: 1704110400,
  },
  {
    id: 2,
    name: 'Balanced Policy',
    description: 'Assigns conversations based on agent capacity',
    assignment_order: 'balanced',
    conversation_priority: 'longest_waiting',
    fair_distribution_limit: 50,
    fair_distribution_window: 1800,
    enabled: false,
    assigned_inbox_count: 1,
    created_at: 1704114000,
    updated_at: 1704114000,
  },
];

export const camelCaseFixtures = [
  {
    id: 1,
    name: 'Round Robin Policy',
    description: 'Distributes conversations evenly among agents',
    assignmentOrder: 'round_robin',
    conversationPriority: 'earliest_created',
    fairDistributionLimit: 100,
    fairDistributionWindow: 3600,
    enabled: true,
    assignedInboxCount: 3,
    createdAt: 1704110400,
    updatedAt: 1704110400,
  },
  {
    id: 2,
    name: 'Balanced Policy',
    description: 'Assigns conversations based on agent capacity',
    assignmentOrder: 'balanced',
    conversationPriority: 'longest_waiting',
    fairDistributionLimit: 50,
    fairDistributionWindow: 1800,
    enabled: false,
    assignedInboxCount: 1,
    createdAt: 1704114000,
    updatedAt: 1704114000,
  },
];
